@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index-2.php">Dashboard </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Admin Dashboard</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="good-morning-blk">
            <div class="row">
                <div class="col-md-6">
                    <div class="morning-user">
                        @php
                        $hour = date('H');

                        if ($hour >= 20) {
                        $greetings = "Good Night";
                        } elseif ($hour > 17) {
                        $greetings = "Good Evening";
                        } elseif ($hour > 11) {
                        $greetings = "Good Afternoon";
                        } elseif ($hour < 12) { $greetings="Good Morning" ; } @endphp <h2>{{$greetings}}, <span>{{auth()->guard('admin')->user()->name}}</span></h2>
                            <p>Have a nice day at work</p>
                    </div>
                </div>
                <div class="col-md-6 position-blk">
                    <div class="morning-img">
                        <img src="assets/img/morning-img-03.png" alt>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <div class="dash-widget">
                    <div class="dash-boxs comman-flex-center">
                        <img src="assets/img/icons/calendar.svg" alt>
                    </div>
                    <div class="dash-content dash-count">
                        <h4>Appointments</h4>
                        <h2><span class="counter-up">{{count(App\Models\Appointments::all())}}</span></h2>
                        <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>40%</span> vs last month</p> -->
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <div class="dash-widget">
                    <div class="dash-boxs comman-flex-center">
                        <img src="assets/img/icons/profile-add.svg" alt>
                    </div>
                    <div class="dash-content dash-count">
                        <h4>Therapist</h4>
                        <h2><span class="counter-up">{{count(App\Models\Therapist::all())}}</span></h2>
                        <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>20%</span> vs last month</p> -->
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <div class="dash-widget">
                    <div class="dash-boxs comman-flex-center">
                        <img src="assets/img/icons/menu-icon-03.svg" alt>
                    </div>
                    <div class="dash-content dash-count">
                        <h4>Clients</h4>
                        <h2><span class="counter-up">{{count(App\Models\User::all())}}</span></h2>
                        <!-- <p><span class="negative-view"><i class="feather-arrow-down-right me-1"></i>15%</span> vs last month</p> -->
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-sm-6 col-lg-6 col-xl-3">
                <div class="dash-widget">
                    <div class="dash-boxs comman-flex-center">
                        <img src="assets/img/icons/tag-icon-01.svg" alt>
                    </div>
                    <div class="dash-content dash-count">
                        <h4>Blogs</h4>
                        <h2>{{count(App\Models\Blog::all())}}</h2>
                        <!-- <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>30%</span> vs last month</p> -->
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-12 col-lg-6 col-xl-8">
                <div class="card">
                    <div class="card-body">
                        <div class="chart-title patient-visit">
                            <h4>Consultation Report</h4>
                            <div class="col-md-5 offset-md-6 form-group mb-0" style="float:right;margin-right: 24px;">
                                <label>Filter Graph by Date</label>
                                <input type="text" class="form-control" id="reportrange">
                            </div>
                            <div id="barchart_material" class=" row mb-5 p-4" style="width: 100%; height: 500px;"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12 col-lg-6 col-xl-4 d-flex">
                <div class="card">
                    <div class="card-body">
                        <div class="chart-title patient-visit mb-0">
                            <h4>Income</h4>
                            <div class="income-value">
                                <h3><span>$</span> 20,560</h3>
                                <p><span class="passive-view"><i class="feather-arrow-up-right me-1"></i>40%</span> vs last month</p>
                            </div>
                            <div class="form-group mb-0">
                                <select class="form-control select">
                                    <option>2023</option>
                                    <option>2022</option>
                                    <option>2021</option>
                                    <option>2020</option>
                                    <option>2019</option>
                                </select>
                            </div>
                        </div>
                        <div id="apexcharts-area"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-12  col-xl-4">
                <div class="card top-departments">
                    <div class="card-header">
                        <h4 class="card-title mb-0 d-inline-block">Therapist List</h4>
                        <a href="{{route('admin.therapist')}}" class="patient-views float-end">Show all</a>
                    </div>
                    <div class="card-body">
                        @foreach(App\Models\Therapist::limit(7)->get() as $item)
                        <div class="activity-top">
                            <div class="activity-boxs comman-flex-center">
                                <img width="28" height="28" class="rounded-circle" src="{{asset('assets/uploads/therapist/' . $item->image)}}" alt="">
                            </div>
                            <div class="departments-list">
                                <h4>{{$item->full_name}}</h4>
                                <p>{{$item->providerCategory->name}}</p>
                                <p>{{$item->professional_credentials}},{{$item->designation}}</p>
                            </div>
                        </div>
                        @endforeach

                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12  col-xl-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-inline-block">Upcoming Appointments</h4> <a href="appointments.php" class="patient-views float-end">Show all</a>
                    </div>
                    <div class="card-body p-0 table-dash">
                        <div class="table-responsive">
                            <table class="table mb-0 border-0 datatable custom-table">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Patient name</th>
                                        <th>Doctor</th>
                                        <th>Time</th>
                                        <th>Call Method</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach(App\Models\Appointments::where('Appointment_Date', '>=', date('Y-m-d'))->orderBy('Appointment_Date', 'DESC')->limit(10)->get() as $item)
                                    <tr>
                                        <td><button class="custom-badge" style="background:{{statusColor($item->Appointment_Status)}};">{{$item->Appointment_Status}}</button></td>
                                        <td>{{$item->user->First_Name}} {{$item->user->Last_Name}}</td>
                                        <td class=" table-image appoint-doctor">
                                            <img width="28" height="28" class="rounded-circle" src="assets/img/profiles/avatar-02.jpg" alt>
                                            <h2>{{$item->therapist->prefix}} {{$item->therapist->full_name}}</h2>
                                        </td>
                                        <td class="appoint-time"><span>{{date('d M Y', strtotime($item->Appointment_Date))}} at </span>{{$item->Appointment_Time}}</td>
                                        <td><button class="custom-badge status-gray ">{{ App\Models\CallMethods::where('id', $item->Appointment_Type)->pluck('name')->first()}}</button></td>
                                        <td class="text-end">
                                            <div class="dropdown dropdown-action">
                                                <a href="#" class="action-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" href="{{route('admin.view-appoinment', ['id' => $item->id])}}"><i class="fa-solid fa-eye m-r-5"></i> View</a>

                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-xl-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title d-inline-block">Packages </h4> <a href="{{route('admin.packages')}}" class="float-end patient-views">show all</a>
                    </div>
                    <div class="card-block table-dash">
                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table datatable mb-0">
                                <thead>
                                    <tr>
                                        <th>
                                            <div class="form-check check-tables">
                                                <input class="form-check-input" type="checkbox" value="something">
                                            </div>
                                        </th>
                                        <th>Package Name</th>
                                        <th>Number of Sessions</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Discount</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach(App\Models\Package::limit(5)->get() as $item)
                                    <tr>
                                        <td>
                                            <div class="form-check check-tables">
                                                <input class="form-check-input" type="checkbox" value="something">
                                            </div>
                                        </td>
                                        <td>{{$item->title}}</td>
                                        <td>{{$item->no_of_sessions }}</td>
                                        <td>{{date('d M Y', strtotime($item->start_date))}}</td>
                                        <td>{{date('d M Y', strtotime($item->endt_date))}}</td>
                                        <td>{{$item->discount}}</td>
                                        <td class="text-end">
                                            <div class="dropdown dropdown-action">
                                                <a href="#" class="action-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">

                                                    <a class="dropdown-item" href="{{route('admin.view-packages', ['slug' => $item->slug])}}"><i class="fa-solid fa-pen-to-square m-r-5"></i> View</a>
                                                    <a class="dropdown-item" href="{{route('admin.edit-packages', ['slug' => $item->slug])}}"><i class="fa-solid fa-pen-to-square m-r-5"></i> Edit</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

    <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script>
        $(function() {

            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);
        });
        google.charts.load('current', {
            'packages': ['bar']
        });
        $('body').on('click', '.applyBtn', function(e) {
            e.preventDefault();
            var url = "{{route('admin.filter-consultation-report')}}";
            var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

            //    $("#js-loader").fadeIn();
            $.ajax({
                type: 'GET',
                url: url,
                data: {
                    from_date: from,
                    to_date: to
                },

                success: function(result) {
                    var data = google.visualization.arrayToDataTable(result);

                    var options = {
                        chart: {
                            title: 'Consultation Report',
                            subtitle: 'Appoinments',
                        },
                    };

                    var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                    chart.draw(data, google.charts.Bar.convertOptions(options));
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });


        $(window).on("load", function() {

            var url = "{{route('admin.filter-consultation-report')}}";
            var from = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var to = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');

            //    $("#js-loader").fadeIn();
            $.ajax({
                type: 'GET',
                url: url,
                data: {
                    from_date: from,
                    to_date: to
                },
                success: function(result) {
                    var data = google.visualization.arrayToDataTable(result);

                    var options = {
                        chart: {
                            title: 'Consultation Report',
                            subtitle: 'Appoinments',
                        },
                    };

                    var chart = new google.charts.Bar(document.getElementById('barchart_material'));
                    chart.draw(data, google.charts.Bar.convertOptions(options));
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection